/*----------------------------------------------------------------------------
 * Name:    service.h
 * Purpose: 
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#ifndef _SERVICE_H_
#define _SERVICE_H_

#include "ht8.h"
#include	"bc7701.h"

/* GAP Service */
#define	GenericAccess							0x1800
#define 	GenericAttribute						0x1801
#define 	Appearance       						0x2A01
#define 	PeripheralPrivacyFlag				0x2A02
/* Device Information Service */
#define	DeviceInformation             	0x180A
#define 	DevInf_SystemID              		0x2A23
#define 	ModelNumberString           		0x2A24
#define 	SerialNumberString          		0x2A25
#define 	FirmwareRevisionString      		0x2A26
#define 	HardwareRevisionString      		0x2A27
#define 	SoftwareRevisionString      		0x2A28
#define 	ManufacturerNameString      		0x2A29
#define 	IEEE11073_20601RegulatoryCertificationDataList	0x2A2A
#define 	DevInf_PnPID              			0x2A50
/* Batter Service */
#define 	Battery                  			0x180F
#define 	BatteryLevel							0x2A19
/* Blood Service */
#define 	BloodPressure							0x1810
#define 	BloodMeasurement						0x2A35
#define 	BloodFeature							0x2A49
/* Weight Scale Service */
#define 	WeightScale								0x181D
#define 	WeightMeasurement						0x2A9D
#define 	WeightFeature							0x2A9E
/* Unknow Service */
#define	UnknowService							0xFFF0
#define 	NotifyFFF1								0xFFF1
#define 	WithoutResponseFFF2					0xFFF2

#define	BCI_ServiceMessage					0x00
#define	BCI_ServiceSupported					0x10
#define	BCI_ServiceProperties				0x20
#define	BCI_ServiceCmdMask					0xF0

/* Service properties(Notify or indicate) status flag define */
typedef union
{
	u8	u;
	struct
	{
		u8 battery:1;
		u8 bps_measurement:1;
		u8 wss_measurement:1;
		u8	uwsFFF1:1;
		u8	:4;
	}b;
}tPROPERTIES;

/** Time profile information
 * date and time structure
 * size = 7 bytes
 */
typedef struct __attribute__((packed))
{
    /// year time element
    u16	year;
    /// month time element
    u8	month;
    /// day time element
    u8	day;
    /// hour time element
    u8	hour;
    /// minute time element
    u8	min;
    /// second time element
    u8	sec;
}tDATA_TIME;

/* Blood Pressure Measurement Flags field bit values	*/
enum
{
    /// pressure in millimetre of mercury
    BPS_FLAG_MMHG                  = 0x00,
    /// Pressure in pascal
    BPS_FLAG_KPA                   = 0x01,
    /// Time Stamp present
    BPS_FLAG_TIME_STAMP_PRESENT    = 0x02,
    /// Pulse Rate present
    BPS_FLAG_PULSE_RATE_PRESENT    = 0x04,
    /// User ID present
    BPS_FLAG_USER_ID_PRESENT       = 0x08,
    /// Measurement Status present
    BPS_FLAG_MEAS_STATUS_PRESENT   = 0x10,
};

/* Blood Pressure Measurement Status Flags field bit values */
enum
{
    /// Body Movement Detection Flag
    /// No body movement
    BPS_STATE_NO_BODY_MVMT_DETECTED       = 0x0000,
    /// Body movement during measurement
    BPS_STATE_BODY_MVMT_DETECTED          = 0x0001,

    /// Cuff Fit Detection Flag
    /// Cuff fits properly
    BPS_STATE_CUFF_FITS_PROPERLY          = 0x0000,
    /// Cuff too loose
    BPS_STATE_CUFF_TOO_LOOSE              = 0x0002,

    /// Irregular Pulse Detection Flag
    /// No irregular pulse detected
    BPS_STATE_NO_IRREGULAR_PULSE_DETECTED = 0x0000,
    /// Irregular pulse detected
    BPS_STATE_IRREGULAR_PULSE_DETECTED    = 0x0004,

    /// Pulse Rate Range Detection Flags
    /// Pulse rate is within the range
    BPS_STATE_PR_IN_RANGE                 = 0x0000,
    /// Pulse rate exceeds upper limit
    BPS_STATE_PR_IN_TOO_HIGH              = 0x0008,
    /// Pulse rate is less than lower limit
    BPS_STATE_PR_IN_TOO_LOW               = 0x0010,

    /// Measurement Position Detection Flag
    /// Proper measurement position
    BPS_STATE_MEAS_POS_OK                 = 0x0000,
    /// Improper measurement position
    BPS_STATE_MEAS_POS_KO                 = 0x0020,
};

/* Blood Pressure Feature Flags field bit values	*/
enum
{
    ///Body Movement Detection Support bit
    ///Body Movement Detection feature not supported
    BPS_F_BODY_MVMT_DETECT_NOT_SUPPORTED         = 0x0000,
    ///Body Movement Detection feature supported
    BPS_F_BODY_MVMT_DETECT_SUPPORTED             = 0x0001,

    ///Cuff Fit Detection Support bit
    ///Cuff Fit Detection feature not supported
    BPS_F_CUFF_FIT_DETECT_NOT_SUPPORTED          = 0x0000,
    ///Cuff Fit Detection feature supported
    BPS_F_CUFF_FIT_DETECT_SUPPORTED              = 0x0002,

    ///Irregular Pulse Detection Support bit
    ///Irregular Pulse Detection feature not supported
    BPS_F_IRREGULAR_PULSE_DETECT_NOT_SUPPORTED   = 0x0000,
    ///Irregular Pulse Detection feature supported
    BPS_F_IRREGULAR_PULSE_DETECT_SUPPORTED       = 0x0004,

    ///Pulse Rate Range Detection Support bit
    ///Pulse Rate Range Detection feature not supported
    BPS_F_PULSE_RATE_RANGE_DETECT_NOT_SUPPORTED  = 0x0000,
    ///Pulse Rate Range Detection feature supported
    BPS_F_PULSE_RATE_RANGE_DETECT_SUPPORTED      = 0x0008,

    ///Measurement Position Detection Support bit
    ///Measurement Position Detection feature not supported
    BPS_F_MEAS_POS_DETECT_NOT_SUPPORTED          = 0x0000,
    ///Measurement Position Detection feature supported
    BPS_F_MEAS_POS_DETECT_SUPPORTED              = 0x0010,

    ///Multiple Bond Support bit
    ///Multiple Bonds not supported
    BPS_F_MULTIPLE_BONDS_NOT_SUPPORTED           = 0x0000,
    ///Multiple Bonds supported
    BPS_F_MULTIPLE_BONDS_SUPPORTED               = 0x0020,
};

/* Blood Pressure Measurement struct define */
typedef struct __attribute__((packed))
{
	u8		Flags;							//Flag
	u16	Systolic;						//Systolic (mmHg/kPa)	
	u16	Diastolic;						//Diastolic (mmHg/kPa)	
	u16	ArterialPressure;				//Mean Arterial Pressure (mmHg/kPa)	
	u8		UserID;							//User ID	
	tDATA_TIME	TimeStamp;				//Time stamp	
	u16	PulseRate;						//Pulse Rate	
	u16	MeasStatus;						//Measurement Status	
}tBPS_MEAS;


/* Weight Scale Feature Flags field bit values	*/
enum
{
    ///Time stamp Support bit
    ///Time stamp feature not supported
    WSS_F_TIME_STAMP_NOT_SUPPORTED      	= 0UL,
    ///Time stamp feature supported
    WSS_F_TIME_STAMP_SUPPORTED         	= (1UL << 0),

    ///Multipe users Support bit
    ///Multipe users feature not supported
    WSS_F_MULTIPLE_USER_NOT_SUPPORTED   	= 0UL,
    ///Multipe users feature supported
    WSS_F_MULTIPLE_USER_SUPPORTED        	= (1UL << 1),

    ///BMI Support bit
    ///BMI feature not supported
    WSS_F_BMI_NOT_SUPPORTED   				= 0UL,
    ///BMI feature supported
    WSS_F_BMI_SUPPORTED   						= (1UL << 2),

    ///Weight measurement resolution bit
    WSS_F_WEIGHT_MEAS_RESOLUTION_05KG_1LB  		= (1UL << 3),
    WSS_F_WEIGHT_MEAS_RESOLUTION_02KG_05LB  		= (2UL << 3),
    WSS_F_WEIGHT_MEAS_RESOLUTION_01KG_02LB  		= (3UL << 3),
    WSS_F_WEIGHT_MEAS_RESOLUTION_005KG_01LB  	= (4UL << 3),
    WSS_F_WEIGHT_MEAS_RESOLUTION_002KG_005LB  	= (5UL << 3),
    WSS_F_WEIGHT_MEAS_RESOLUTION_001KG_002LB  	= (6UL << 3),
    WSS_F_WEIGHT_MEAS_RESOLUTION_0005KG_001LB 	= (7UL << 3),

    ///Height measurement resolution bit	 
    WSS_F_HEIGHT_MEAS_RESOLUTION_001M_1I  	= (1UL << 7),	 
    WSS_F_HEIGHT_MEAS_RESOLUTION_0005M_05I  	= (2UL << 7),	 
    WSS_F_HEIGHT_MEAS_RESOLUTION_0001M_01I  	= (3UL << 7)
};

/* Weight Measurement Flags field bit values	*/
enum
{
    /// Imperial Measurement Units (weight in lb and height in inches)
    WSS_MEAS_FLAG_UNIT_IMPERIAL      = 0x01,
    /// Time Stamp present
    WSS_MEAS_FLAG_TIME_STAMP         = 0x02,
    /// User ID present
    WSS_MEAS_FLAG_USERID_PRESENT     = 0x04,
    /// BMI & Height present
    WSS_MEAS_FLAG_BMI_HT_PRESENT     = 0x08,
};

/* Weight measurement structure	*/
typedef struct __attribute__((packed))
{
   u8		Flags;							// Flags	
   u16	Weight;							// Weight	
	tDATA_TIME	TimeStamp;				// Time stamp	
	u8		UserID;							// User ID	
   u16	BMI;								// BMI	
	u16	Height;							// Height	
}tWSS_MEAS;

#endif	/* _SERVICE_H_ */
